/*
 * XXXX 
 *
 * Fecha 14/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet.presentacion.DEC;


import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xml.security.utils.Base64;

import com.ejie.p06b.datatype.logic.P06BError;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BPage;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.datatype.model.P06B31T00Datatype;
import com.ejie.p06b.datatype.model.P06B83T00Datatype;
import com.ejie.p06b.upload.p06bRequest;
import com.ejie.p06b.upload.p06bSmartUpload;
import com.ejie.p06b.upload.p06bFile;



/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BDatosDireccionServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			int accion = 0;
			String descDireccionEus = "";
			String descDireccionCas = "";
			String nombre = "";
			String ape1 = "";
			String ape2 = "";
			String imagenBase64 = "";
			String tipoImagenFirma = "";
			String tipoImagenFirmaAnterior = "";
			byte[] imagenFirma = null;
			
            String fileName = "";
			if (request.getParameter("accion")==null){
				
				List<FileItem> items = new ServletFileUpload(new DiskFileItemFactory()).parseRequest(request);
				for (FileItem item : items) {
	                if (item.isFormField()) {
	                    // Process regular form field (input type="text|radio|checkbox|etc", select, etc).
	                    String fieldName = item.getFieldName();
	                    String fieldValue = new String(item.get(),"UTF-8");
	                    // ... (do your job here)
	                            
	                    if(fieldName != null && fieldName.equals("accion")){
	                        accion = Integer.parseInt(fieldValue);
	                    }else if(fieldName != null && fieldName.equals("descDireccionEus_datosDireccModif")){
	                    	descDireccionEus = fieldValue;
	                    }else if(fieldName != null && fieldName.equals("descDireccionCas_datosDireccModif")){
	                    	descDireccionCas = fieldValue;
	                    }else if(fieldName != null && fieldName.equals("nombre_datosDireccModif")){
	                    	nombre = fieldValue;
	                    }else if(fieldName != null && fieldName.equals("ape1_datosDireccModif")){
	                    	ape1 = fieldValue;
	                    }else if(fieldName != null && fieldName.equals("ape2_datosDireccModif")){
	                    	ape2 = fieldValue;
	                    }else if(fieldName != null && fieldName.equals("tipoImagenFirma")){
	                    	tipoImagenFirmaAnterior = fieldValue;
	                    }else if(fieldName != null && fieldName.equals("imagenBase64")){
	                    	imagenBase64 = fieldValue;
	                    }
	                } else {
	                    // Process form file field (input type="file").
	                    String fieldName = item.getFieldName();
	                    fileName = FilenameUtils.getName(item.getName());
//	                    if (!"".equals(fileName) && item.getSize()>0){
	                    InputStream fileContent = item.getInputStream();
	                    // ... (do your job here)
	                    tipoImagenFirma = item.getContentType();
	                    imagenFirma = IOUtils.toByteArray(fileContent);	                    	
//	                    }
	                }
	            }				
			}else{
				accion = Integer.parseInt(request.getParameter("accion"));
			}
			
	
			P06B83T00Datatype datosDireccion = null;
			switch (accion){
				case P06BConstantes.P06B_ACCION_RECUPERAR:
					datosDireccion = P06BCorredoresManager.getInstance().selectDatosDireccion();
					datosDireccion.setTipoImagenFirmaUltimoIntentoGrabacion(datosDireccion.getTipoImagenFirma());
					break;					
				case P06BConstantes.P06B_ACCION_UPDATE:
					datosDireccion = P06BCorredoresManager.getInstance().selectDatosDireccion();
					datosDireccion.setDescDireccionEus(descDireccionEus);
					datosDireccion.setDescDireccionCas(descDireccionCas);
					datosDireccion.setNombre(nombre);
					datosDireccion.setApe1(ape1);
					datosDireccion.setApe2(ape2);
					datosDireccion.setTipoImagenFirma(tipoImagenFirmaAnterior);
					datosDireccion.setTipoImagenFirmaUltimoIntentoGrabacion(tipoImagenFirmaAnterior);
					datosDireccion.setImagenFirmaBase64(imagenBase64);
					datosDireccion.setImagenFirma(Base64.decode(imagenBase64));
					
					P06BCorredoresManager.getInstance().updateAll(datosDireccion);
					break;
				case P06BConstantes.P06B_ACCION_UPDATEIMAGE:
					datosDireccion = P06BCorredoresManager.getInstance().selectDatosDireccion();
					datosDireccion.setDescDireccionEus(descDireccionEus);
					datosDireccion.setDescDireccionCas(descDireccionCas);
					datosDireccion.setNombre(nombre);
					datosDireccion.setApe1(ape1);
					datosDireccion.setApe2(ape2);
					if (tipoImagenFirma.equals("image/gif") || tipoImagenFirma.equals("image/jpeg")){
						datosDireccion.setTipoImagenFirma(tipoImagenFirma);
						datosDireccion.setTipoImagenFirmaUltimoIntentoGrabacion(tipoImagenFirma);						
						datosDireccion.setImagenFirma(imagenFirma);
						String base64 = Base64.encode(imagenFirma);
						datosDireccion.setImagenFirmaBase64(base64);
					}else{
						datosDireccion.setTipoImagenFirma(tipoImagenFirmaAnterior);
						datosDireccion.setTipoImagenFirmaUltimoIntentoGrabacion("");							
						datosDireccion.setImagenFirmaBase64(imagenBase64);
						datosDireccion.setImagenFirma(Base64.decode(imagenBase64));
					}
					break;
			}
			request.setAttribute("datosDireccion", datosDireccion);
			forward (request, response, P06BPaginas.P06B_JSP_DATOSDIRECCION);
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
	
}